package net.w_horse.excelpojo.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import net.w_horse.excelpojo.xml.tag.RetrieveFrom;
import net.w_horse.excelpojo.xml.tag.RetrieveType;
import net.w_horse.excelpojo.xml.tag.Use;


@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Bean {
	String sheetName() default "";

	RetrieveType retrieveType() default RetrieveType.NONE;
	String label() default "";
	String position() default "";
	String previousLabel() default "";
	RetrieveFrom retrieveFrom() default RetrieveFrom.NONE;
	String terminate() default "";
	boolean margedRows() default false;
	int margedLabel() default 0;
	Use use() default Use.NONE;
	String listClass() default "";
	String range() default "";
}

